%%%%%%
%
%
%
%%%%%%
function BuildAugmentedPointModels
augmentdir = [pwd, filesep, 'Data'];
augmentinfoname = [augmentdir filesep, 'augment_info.mat'];
if ~exist(augmentinfoname);
    fprintf('There is no augmentation information file in <project_dir>/Data directory\n');
    return;
end
templatename = getTemplateName;
if isempty(templatename)
    fprintf('User clicked cancel, aborting build.\n');
    return;
end
pmdir = [pwd, filesep, 'PointModels', filesep, templatename];
if ~exist(pmdir, 'dir')
    mkdir(pmdir);
end

augment_info = load(augmentinfoname);
augment_info = augment_info.augment_info;
if ~isfield(augment_info, 'ordered_pmfiles')
    str = sprintf('You have not ordered your Point Model files, please do this first.');
    uiwait(msgbox(str,'Order Point Models First','modal'));
    return;
end

augmentdir = [pwd, filesep, 'Data'];
PMORDERINFO_XLS_NAME = [augmentdir filesep, 'PMORDERINFO_XLS.xls'];
if ~exist(PMORDERINFO_XLS_NAME)
    str = sprintf('You have not ordered your Point Model files, please do this first.');
    uiwait(msgbox(str,'Order Point Models First','modal'));
    return;
end
[NUMERIC,TXT]=xlsread(PMORDERINFO_XLS_NAME, 'PM Ordering');
% Just delete the project name from the data.
TXT(1,:) = [];
for i=1:size(TXT,2)
    prj_pmfiles = {TXT{:,i}}';
    indx = [];
    for ii=1:length(prj_pmfiles)
        if isempty(prj_pmfiles{ii})
            indx(end+1) = ii;
        end
    end
    prj_pmfiles(indx) = [];
    ordered_pmfiles{i} = prj_pmfiles;
end
N = findMaxFilesToAugment(ordered_pmfiles);
ALLP = {};
opts = ProcrustesParamsDlg;
if length(opts)<4
    normalise_mean_size_flag = 1;
else
    normalise_mean_size_flag = opts(4);
end
for p=1:length(augment_info)
    ainfo = augment_info(p);
    [projdir, projname, ext, vers] = fileparts(ainfo.projectdir);
    P = [];
    pmfiles = ordered_pmfiles{p};
    names = {ainfo.pmfiles.filename};
    waitbar_h = waitbar(0, sprintf('Building augmented PM files\nfor %s...', projname));
    set(findall(waitbar_h,'type','text'),'Interpreter','none');
    for i=1:N
        waitbar(i/N, waitbar_h);
        indx = find(strcmp(pmfiles{i}, names));
        if ~isempty(indx)
            fprintf('Build with filename %s\n', pmfiles{i});
            P(:,end+1) = ainfo.pmfiles(indx).pts;
        end
    end
    close(waitbar_h);
    [PAligned,ProcrustesAlignment] = pmalign(P,opts);
    ALLP{end+1} = PAligned;
end
if normalise_mean_size_flag
    ALLP = normalise_mean_size(ALLP);
    showdata(ALLP);
end
for i=1:N
    allpts = [];
    pmname = [augment_info(1).ordered_pmfiles{i}];
    for p=1:length(ALLP)
        pts = ALLP{p}(:,i);
        pts = reshape(pts, 2, length(pts)/2);
        allpts = [allpts, pts];
    end
    pts = allpts(:);
    save([pmdir, filesep, pmname], 'pts');
end
%%%%%%
%
%
%
%%%%%%
function showdata(ALLP)
for j=1:length(ALLP)
    X = ALLP{j};
    figure; hold on;
    for i=1:size(X,2)
        x = X(:,i);
        x = reshape(x, 2, length(x)/2);
        plot(x(1,:), x(2,:), 'ro-');
    end
    meanshape = mean(X, 2);
    meanshape = reshape(meanshape, 2, length(meanshape)/2);
    
    centroid = mean(meanshape, 2);
    centered_meanshape = meanshape - centroid*ones(1, size(meanshape,2));
    sz = norm(centered_meanshape(:))

    plot(meanshape(1,:), meanshape(2,:), 'go-');
    axis image;
end
return;

%%%%%%
%
%
%
%%%%%%
function ALLX = normalise_mean_size(ALLX)
% Here we assume that each column is an observation and each row is a
% variable.
for j=1:length(ALLX)
    X = ALLX{j};
    meanshape = mean(X, 2);
    meanshape = reshape(meanshape, 2, length(meanshape)/2);
    centroid = mean(meanshape, 2);
    centered_meanshape = meanshape - centroid*ones(1, size(meanshape,2));
    sz(j) = norm(centered_meanshape(:));
end
newsz = mean(sz);
for j=1:length(ALLX)
    X = ALLX{j};
    scale = newsz/sz(j);
    for i=1:size(X, 2)
        x = X(:,i);
        x = reshape(x, 2, length(x)/2);
        mu = mean(x, 2);
        x = x - mu*ones(1, size(x, 2));
        x = x.*scale;
        X(:,i) = x(:);
    end
    ALLX{j} = X;
end
return;

%%%%%%
%
%
%
%%%%%%
function N = findMaxFilesToAugment(ordered_pmfiles)
for i=1:length(ordered_pmfiles)
    pmfiles =  ordered_pmfiles{i};
    N(i) = length(pmfiles);
end
N = min(N);
return;
%%%%%%
%
%
%
%%%%%%
function templatename = getTemplateName
templatename = [];
[filename, pathname] = uigetfile('*.temp_dat', 'Pick a Template-file', ['Templates', filesep]);
if isequal(filename,0) || isequal(pathname,0)
    disp('User pressed cancel')
else
    [pathname, templatename, ext, vers] = fileparts(filename);
    disp(['User selected ', fullfile(pathname, filename)])
end