clear all;
IS = imread('Textures\busX4.tif');
%IS = imread('rice.tif');
img(:,:,1) = IS;
img(:,:,2) = IS;
img(:,:,3) = IS;
img = uint8(img);

r = img(:,:,1)';
g = img(:,:,2)';
b = img(:,:,3)';
k = [r(:) g(:) b(:)]';
k = reshape(k(:),size(img,2),size(img,1),3);

% Warp the image
tic
timg = glShader(k);
shader_time = toc

tic
IO = edge(IS, 'sobel');
matlab_time = toc

siz = size(timg);
timg = timg(:);
wimg(:,:,1) = reshape(timg(1:3:length(timg)),siz(1),siz(2))';
wimg(:,:,2) = reshape(timg(2:3:length(timg)),siz(1),siz(2))';
wimg(:,:,3) = reshape(timg(3:3:length(timg)),siz(1),siz(2))';
%figure;
%imagesc(wimg); axis image;

figure;
subplot(2,2,1);
imshow(IS);
subplot(2,2,2);
imshow(wimg);
subplot(2,2,3);
imshow(IO);
subplot(2,2,4);
bar(shader_time, matlab_time);

clear all;