clear all;
IS = imread('pout.tif');
img(:,:,1) = IS;
img(:,:,2) = IS;
img(:,:,3) = IS;
img = uint8(img);
N = 20;
ipts = rand(N,2);
ipts(:,1) = ipts(:,1) * size(img,2);
ipts(:,2) = ipts(:,2) * size(img,1);

opts = rand(N,2);
opts(:,1) = opts(:,1) * size(img,2);
opts(:,2) = opts(:,2) * size(img,1);
T = delaunay(ipts(:,1),ipts(:,2),{'Qt','Qbb','Qc','Qz'});
figure(1); clf; hold on;
imagesc(img);
triplot(T, ipts(:,1),ipts(:,2), 'Color', 'r');
triplot(T, opts(:,1),opts(:,2));
axis image ij;
tri = T;
tri = tri';
tri = tri(:);

ipts = ipts(tri,:)';
ipts = single(ipts(:));
opts = opts(tri,:)';
opts = single(opts(:));

r = img(:,:,1)';
g = img(:,:,2)';
b = img(:,:,3)';
k = [r(:) g(:) b(:)]';
k = reshape(k(:),size(img,2),size(img,1),3);

% Warp the image with WIN
tic
timg = gltriwarp(k,ipts,opts);
win_time = toc
siz = size(timg);
timg = timg(:);
wimg(:,:,1) = reshape(timg(1:3:length(timg)),siz(1),siz(2))';
wimg(:,:,2) = reshape(timg(2:3:length(timg)),siz(1),siz(2))';
wimg(:,:,3) = reshape(timg(3:3:length(timg)),siz(1),siz(2))';
figure;
imagesc(wimg); axis image;

% Warp the image with GLUT
tic
timg = glutTriWarp(k,ipts,opts);
glut_time = toc
siz = size(timg);
timg = timg(:);
wimg(:,:,1) = reshape(timg(1:3:length(timg)),siz(1),siz(2))';
wimg(:,:,2) = reshape(timg(2:3:length(timg)),siz(1),siz(2))';
wimg(:,:,3) = reshape(timg(3:3:length(timg)),siz(1),siz(2))';
figure;
imagesc(wimg); axis image;