function [opts] = ProcrustesParamsDlg(varargin)
%
%   Dr. A. I. Hanna (2005) CMP, UEA, 2005.
error(nargchk(0,inf,nargin));
ad.opts = [1 1 1];
% Open, move, and get the handles from the figure file.
fig = openfig(mfilename, 'reuse');
% Move the gui and then show it, rather than have it jump all over the
% place.
movegui(fig, 'center');
set(fig, 'visible', 'on');
handles = guihandles(fig);
set(fig, 'Color', get(handles.uipanel1, 'BackgroundColor'))
% Set all the callback functions
set(handles.ok_btn, 'callback', {@doOk});
set(handles.cancel_btn, 'callback', {@doCancel});
% Initialize the application data structure
ad.figMain = fig;
ad.handles = handles;
setappdata(0,'ProcrustesParamsDlgData',ad);
try
    uiwait(fig);
catch
    if ishandle(fig)
        delete(fig)
    end
end
if isappdata(0,'ProcrustesParamsDlgData')
    ad = getappdata(0,'ProcrustesParamsDlgData');
    opts = ad.opts;
    rmappdata(0,'ProcrustesParamsDlgData')
else
    % figure was deleted
    opts = [1 1 1 1];
end
return;
function doOk(ok_btn, evd)
ad = getappdata(0,'ProcrustesParamsDlgData');
ad.opts = [get(ad.handles.scale_chk, 'Value'), get(ad.handles.rot_chk, 'Value'), get(ad.handles.trans_chk, 'Value'), get(ad.handles.normmeanschk, 'Value')];
delete(gcbf);
setappdata(0,'ProcrustesParamsDlgData', ad);
function doCancel(cancel_btn, evd)
ad = getappdata(0,'ProcrustesParamsDlgData');
ad.opts = [1 1 1 1];
delete(gcbf);
setappdata(0,'ProcrustesParamsDlgData', ad);
