function makeCircle(shapedir, templatename, iminfo)
N = max(iminfo.Height, iminfo.Width);
rad = N/3;
[x, y] = meshgrid(1:N);
I = sqrt((x-N/2).^2 + (y-N/2).^2);
Ibin = I<rad;
I(:,:,1) = Ibin;
I(:,:,2) = Ibin;
I(:,:,3) = Ibin;

[filename, pathname] = uiputfile(['Cropped', filesep, '*.JPG'], 'Pick an JPG-file');
if isequal(filename,0) || isequal(pathname,0)
    disp('User pressed cancel')
    return;
else
    disp(['User selected ', fullfile(pathname, filename)])
    imwrite(I, [pathname, filesep, filename], 'JPEG');
end