function [X] = mean_group_image(templatename, pm_files, Xm)

pmprefix = [pwd, filesep, 'PointModels', filesep, templatename, filesep];
images_dir = 'Cropped';
prefix = [pwd, filesep, images_dir, filesep];
X = [];
Xm = (reshape(Xm, 2, length(Xm)/2))';
for i=1:length(pm_files)
    file = pm_files{i};
    pmfile = [pmprefix, file];
    if exist(pmfile)
        pts = load(pmfile);
        pts = pts.pts;
        pts = (reshape(pts, 2, length(pts)/2))';

        [path, file, ext, vers] = fileparts(file);
        file = [file(1:end-3), '.jpg'];
        if exist([prefix, file])
            I = imread([prefix, file]);
            [wimg] = triwarp(I, pts, Xm, []);
            if isempty(X)
                X = double(wimg(:));
            else
                X = X + double(wimg(:));
            end

        else
            fprintf('Could not file file %s\n', [prefix, pm_files{i}]);
        end
    end
end

X = X./length(pm_files);
X = mean(X,2);
X = uint8(reshape(X, size(wimg)));