%
%
% [B, sorted_edge] = SegLeafFromBackground(I);
%
% Input params: 
%            I - the input image
% Output params:
%            B - the binary image
%            sorted_edge - the edge of the objects in B, ordered.
%
%  Dr. A. I. Hanna 2005.
function [B, sorted_edge] = Segment_Red_Petals_BlueBackgound(I)
I = double(I);
I = I./max(I(:));
B = calcRedPetalBlueBackgroundBinim(I);
E = edge(double(B));
[x, y] = find(E == 1);
if length(x)>0
    sorted_edge = image_sort(x,y); 
    %sorted_edge = sort_coord_pixel([x, y], 'clockwise', 'discontinuous');
else
    sorted_edge = E;
end
return;
function [binim] = calcRedPetalBlueBackgroundBinim(im);
p = im(:,:,2) + im(:,:,3);
p = p./max(p(:));
p = imadjust(p, stretchlim(p), []);
binim = p <.5;
binim = bwareaopen(binim, 2000);
binim = imclearborder(binim);
binim = bwfill(binim,'holes', 4);
return;

