
int print_Ogl_Error(char *file, int line)
{
    //
    // Returns 1 if an OpenGL error occurred, 0 otherwise.
    //
    GLenum glErr;
    int    retCode = 0;

    glErr = glGetError();
    while (glErr != GL_NO_ERROR)
    {
        cout<<"GLERROR: in file "<<file<<" @ line: "<<line<<" "<<gluErrorString(glErr)<<endl;
        retCode = 1;
        glErr = glGetError();
    }
    return retCode;
}

GL_Ext::GL_Ext()
{

}

GL_Ext::~GL_Ext()
{

}

int GL_Ext::check_GLextension(char* extensionName)
{
  // get the list of supported extensions
  char* extensionList = (char*) glGetString(GL_EXTENSIONS);

  if (!extensionName || !extensionList)
  {
      cout<<"ERROR: No extensionName or extensionList... [check_GLextension(), GL_Ext_Loader.cpp]"<<endl;
    return 0;
  }

  while (*extensionList)
  {
    // find the length of the first extension substring
    unsigned int firstExtensionLength = strcspn(extensionList, " ");


    if (strlen(extensionName) == firstExtensionLength &&
      strncmp(extensionName, extensionList, firstExtensionLength) == 0)
    {
	  cout<<"EXT: Using: "<<extensionName<<endl;
      return 1;
    }

    // move to the next substring
    extensionList += firstExtensionLength + 1;
  }

  cout<<"ERROR: Extension not supported: "<<extensionName<<endl;
  return 0;
}

void GL_Ext::load_GLextension(void)
{
	int error=0;

	if(!check_GLextension("GL_EXT_framebuffer_object"))
	{
   	    mexErrMsgTxt("ERROR: GL_EXT_framebuffer_object extension not available... [load_GLextension(), GL_Ext_Loader.h]");
        cout<<"ERROR: GL_EXT_framebuffer_object extension not available... [load_GLextension(), GL_Ext_Loader.h]"<<endl;
	}

    error |= GETGLPROC(PFNGLISRENDERBUFFEREXTPROC, glIsRenderbufferEXT);
    error |= GETGLPROC(PFNGLBINDRENDERBUFFEREXTPROC, glBindRenderbufferEXT);
//    error |= GETGLPROC(PFNGLDELETERENDERBUFFERSEXTPROC, glGenRenderbuffersEXT);
    error |= GETGLPROC(PFNGLRENDERBUFFERSTORAGEEXTPROC, glRenderbufferStorageEXT);

    error |= GETGLPROC(PFNGLGETRENDERBUFFERPARAMETERIVEXTPROC, glGetRenderbufferParameterivEXT);
    error |= GETGLPROC(PFNGLISFRAMEBUFFEREXTPROC, glIsFramebufferEXT);
    error |= GETGLPROC(PFNGLBINDFRAMEBUFFEREXTPROC, glBindFramebufferEXT);
    error |= GETGLPROC(PFNGLDELETEFRAMEBUFFERSEXTPROC, glDeleteFramebuffersEXT);

    error |= GETGLPROC(PFNGLGENFRAMEBUFFERSEXTPROC, glGenFramebuffersEXT);
    error |= GETGLPROC(PFNGLCHECKFRAMEBUFFERSTATUSEXTPROC, glCheckFramebufferStatusEXT);
    error |= GETGLPROC(PFNGLFRAMEBUFFERTEXTURE1DEXTPROC, glFramebufferTexture1DEXT);
    error |= GETGLPROC(PFNGLFRAMEBUFFERTEXTURE2DEXTPROC, glFramebufferTexture2DEXT);

    error |= GETGLPROC(PFNGLFRAMEBUFFERTEXTURE3DEXTPROC, glFramebufferTexture3DEXT);
    error |= GETGLPROC(PFNGLFRAMEBUFFERRENDERBUFFEREXTPROC, glFramebufferRenderbufferEXT);
    error |= GETGLPROC(PFNGLGETFRAMEBUFFERATTACHMENTPARAMETERIVEXTPROC, glGetFramebufferAttachmentParameterivEXT);
    error |= GETGLPROC(PFNGLGENERATEMIPMAPEXTPROC, glGenerateMipmapEXT);

     if( error )
    {
        cout<<"ERROR: from GETGLPROC... [load_GLextension(), GL_Ext_Loader.h]"<<endl;
    }
	 
    if ( !check_GLextension( "GL_ARB_shader_objects" )   ||
         !check_GLextension( "GL_ARB_fragment_shader" )  ||
         !check_GLextension( "GL_ARB_vertex_shader" )    ||
         !check_GLextension( "GL_ARB_shading_language_100" ) )
    {
   	    mexErrMsgTxt("ERROR: OpenGL Shading Language extensions not available... [load_GLextension(), GL_Ext_Loader.h]");
        cout<<"ERROR: OpenGL Shading Language extensions not available... [load_GLextension(), GL_Ext_Loader.h]"<<endl;
		system("pause");
//		exit(1);
    }

    error |= GETGLPROC(PFNGLCREATEPROGRAMOBJECTARBPROC, glCreateProgramObjectARB);
    error |= GETGLPROC(PFNGLCREATESHADEROBJECTARBPROC, glCreateShaderObjectARB);
    error |= GETGLPROC(PFNGLDELETEOBJECTARBPROC, glDeleteObjectARB);
    error |= GETGLPROC(PFNGLDETACHOBJECTARBPROC, glDetachObjectARB);
    error |= GETGLPROC(PFNGLATTACHOBJECTARBPROC, glAttachObjectARB);
    error |= GETGLPROC(PFNGLSHADERSOURCEARBPROC, glShaderSourceARB);
    error |= GETGLPROC(PFNGLCOMPILESHADERARBPROC, glCompileShaderARB);
    error |= GETGLPROC(PFNGLLINKPROGRAMARBPROC, glLinkProgramARB);
    error |= GETGLPROC(PFNGLGETINFOLOGARBPROC, glGetInfoLogARB);
    error |= GETGLPROC(PFNGLUSEPROGRAMOBJECTARBPROC, glUseProgramObjectARB);
    error |= GETGLPROC(PFNGLGETOBJECTPARAMETERIVARBPROC, glGetObjectParameterivARB);
    error |= GETGLPROC(PFNGLGETOBJECTPARAMETERFVARBPROC, glGetObjectParameterfvARB);
    error |= GETGLPROC(PFNGLGETUNIFORMLOCATIONARBPROC, glGetUniformLocationARB);
    error |= GETGLPROC(PFNGLBINDATTRIBLOCATIONARBPROC, glBindAttribLocationARB);
    error |= GETGLPROC(PFNGLUNIFORM1FARBPROC, glUniform1fARB);
    error |= GETGLPROC(PFNGLUNIFORM2FARBPROC, glUniform2fARB);
    error |= GETGLPROC(PFNGLUNIFORM3FARBPROC, glUniform3fARB);
    error |= GETGLPROC(PFNGLUNIFORM4FARBPROC, glUniform4fARB);
    error |= GETGLPROC(PFNGLUNIFORM1IARBPROC, glUniform1iARB);
    error |= GETGLPROC(PFNGLUNIFORM2IARBPROC, glUniform2iARB);
    error |= GETGLPROC(PFNGLUNIFORM3IARBPROC, glUniform3iARB);
    error |= GETGLPROC(PFNGLUNIFORM4IARBPROC, glUniform4iARB);
    error |= GETGLPROC(PFNGLUNIFORM1FVARBPROC, glUniform1fvARB);
    error |= GETGLPROC(PFNGLUNIFORM2FVARBPROC, glUniform2fvARB);
    error |= GETGLPROC(PFNGLUNIFORM3FVARBPROC, glUniform3fvARB);
    error |= GETGLPROC(PFNGLUNIFORM4FVARBPROC, glUniform4fvARB);
    error |= GETGLPROC(PFNGLUNIFORM1IVARBPROC, glUniform1ivARB);
    error |= GETGLPROC(PFNGLUNIFORM2IVARBPROC, glUniform2ivARB);
    error |= GETGLPROC(PFNGLUNIFORM3IVARBPROC, glUniform3ivARB);
    error |= GETGLPROC(PFNGLUNIFORM4IVARBPROC, glUniform4ivARB);
    error |= GETGLPROC(PFNGLVERTEXATTRIB4FVARBPROC, glVertexAttrib4fvARB);
    error |= GETGLPROC(PFNGLVERTEXATTRIB3FVARBPROC, glVertexAttrib3fvARB);
    error |= GETGLPROC(PFNGLVERTEXATTRIB2FVARBPROC, glVertexAttrib2fvARB);
    error |= GETGLPROC(PFNGLVERTEXATTRIB1FVARBPROC, glVertexAttrib1fvARB);
    error |= GETGLPROC(PFNGLVERTEXATTRIB4FARBPROC, glVertexAttrib4fARB);
    error |= GETGLPROC(PFNGLVERTEXATTRIB3FARBPROC, glVertexAttrib3fARB);
    error |= GETGLPROC(PFNGLVERTEXATTRIB2FARBPROC, glVertexAttrib2fARB);
    error |= GETGLPROC(PFNGLVERTEXATTRIB1FARBPROC, glVertexAttrib1fARB);

    error |= GETGLPROC(PFNGLVERTEXATTRIBPOINTERARBPROC, glVertexAttribPointerARB);
    error |= GETGLPROC(PFNGLENABLEVERTEXATTRIBARRAYARBPROC, glEnableVertexAttribArrayARB);
    error |= GETGLPROC(PFNGLDISABLEVERTEXATTRIBARRAYARBPROC, glDisableVertexAttribArrayARB);

    error |= GETGLPROC(PFNGLTEXIMAGE3DPROC, glTexImage3D);
    error |= GETGLPROC(PFNGLACTIVETEXTUREPROC, glActiveTexture);

    if( error )
    {
        cout<<"ERROR: from GETGLPROC... [load_GLextension(), GL_Ext_Loader.h]"<<endl;
    }
}