#include "GL_Render2Texture.h"

void GL_Render2Texture::create(int size, int channels, int type)										
{
	// Create a pointer to store the blank image data
	unsigned int *pTexture = NULL;											

	// We need to create a blank texture to render our dynamic texture too.
	// To do this, we just create an array to hold the data and then give this
	// array to OpenGL.  The texture is stored on the video card so we can
	// destroy the array immediately afterwards.
	// This function takes the texture array to store the texture, the
	// size of the texture for width and the heigth, the channels (1, 3 or 4),
	// the type (LUMINANCE, RGB, RGBA, etc..) and the texture ID to assign it too.

	// Allocate and init memory for the image array and point to it from pTexture
	pTexture = new unsigned int [size * size * channels];
	memset(pTexture, 0, size * size * channels * sizeof(unsigned int));	

	// Register the texture with OpenGL and bind it to the texture ID
	glGenTextures(1, &texture);								
	glBindTexture(GL_TEXTURE_2D, texture);					
	
	// Create the texture and store it on the video card
	glTexImage2D(GL_TEXTURE_2D, 0, channels, size, size, 0, type, GL_UNSIGNED_INT, pTexture);						
	
	// Set the texture quality
	glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_MIN_FILTER,GL_LINEAR);
	glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_MAG_FILTER,GL_LINEAR);

	// Since we stored the texture space with OpenGL, we can delete the image data
	delete [] pTexture;																					
}
void GL_Render2Texture::enable(int view_size)
{
	// Push on a new matrix scope
	glPushMatrix();	
	
	// Now comes the part where we actually render to the texture.
	// First, let's create a small viewport to render to.  This way we
	// don't create a huge texture that is the size of our screen width and height.
	// We can then render from this screen size to the texture map.

	// Shrink the viewport by the current viewport size.  We have an option
	// to change the viewport in real time by pressing 1, 2, or 3.  You will see
	// the difference in quality between 128, 256 and 512 texture sizes.
	//glViewport(0, 0, view_size, view_size);								

}

void GL_Render2Texture::disable(int view_size)
{
	// Before we copy the screen to a texture, we need to specify the current
	// texture to draw to by calling glBindTexture() with the appropriate texture 
	glBindTexture(GL_TEXTURE_2D, texture);				

	// Now comes the moment we have all been waiting for, we render the screen
	// to the texture.  We pass in the texture type, detail level (0), pixel format,
	// the x and y position to start from, the width and height to grab, and a border.
	// If you only want a part of the screen, this works great for that.
	glCopyTexImage2D(GL_TEXTURE_2D, 0, GL_RGB, 0, 0, view_size, view_size, 0);

	// Here we clear the screen and depth bits of the small viewport
	glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);			

	// Set our viewport back to it's normal size
	//glViewport(0, 0, width, height);	

	// Make the color of the background black for the texture map
	glClearColor(0.5 ,0.5, 0.5, 1.0);

	// Return matrix back to normal	
	glPopMatrix();
}