varying vec2 TexCoord;				// current texcoord
uniform sampler2D src;				// texture to sample

uniform float	texwidth;			// texture_width

void main()
{
	float stepsize	= 1.0/texwidth;

	mat3 filter;
	filter[0][0] = 1.0;		filter[0][1] = 	2.0;	filter[0][2] = 1.0; 
	filter[1][0] = 0.0;		filter[1][1] = 	0.0;	filter[1][2] = 0.0; 
	filter[2][0] = -1.0;	filter[2][1] = 	-2.0;	filter[2][2] = -1.0; 
	
	vec4 norm = vec4(1.0);

	//====================================================================================
	vec4 finalcolor_H = texture2D(src,TexCoord+vec2(-stepsize,stepsize))  * filter[0][0];
	finalcolor_H += texture2D(src,TexCoord+vec2(0, stepsize))  * filter[0][1];
	finalcolor_H += texture2D(src,TexCoord+vec2(stepsize, stepsize))  * filter[0][2];

	finalcolor_H += texture2D(src,TexCoord+vec2(-stepsize,0))  * filter[1][0];
	finalcolor_H += texture2D(src,TexCoord)* filter[1][1];
	finalcolor_H += texture2D(src,TexCoord+vec2(stepsize,0))   * filter[1][2];

	finalcolor_H += texture2D(src,TexCoord+vec2(-stepsize,-stepsize)) * filter[2][0];
	finalcolor_H += texture2D(src,TexCoord+vec2(0,-stepsize))  * filter[2][1];
	finalcolor_H += texture2D(src,TexCoord+vec2(stepsize,-stepsize))  * filter[2][2];
	finalcolor_H /= norm;

	//====================================================================================
	vec4 finalcolor_V = texture2D(src,TexCoord+vec2(-stepsize,stepsize))  * filter[2][0];
	finalcolor_V += texture2D(src,TexCoord+vec2(0, stepsize))  * filter[1][0];
	finalcolor_V += texture2D(src,TexCoord+vec2(stepsize, stepsize))  * filter[0][0];

	finalcolor_V += texture2D(src,TexCoord+vec2(-stepsize,0))  * filter[2][1];
	finalcolor_V += texture2D(src,TexCoord)* filter[1][1];
	finalcolor_V += texture2D(src,TexCoord+vec2(stepsize,0))   * filter[0][1];

	finalcolor_V += texture2D(src,TexCoord+vec2(-stepsize,-stepsize)) * filter[2][2];
	finalcolor_V += texture2D(src,TexCoord+vec2(0,-stepsize))  * filter[1][2];
	finalcolor_V += texture2D(src,TexCoord+vec2(stepsize,-stepsize))  * filter[0][2];
	finalcolor_V /= norm;

	vec4 temp1 = finalcolor_H * finalcolor_H;
	vec4 temp2 = finalcolor_V * finalcolor_V;
	vec4 temp3 = temp1+temp2;

	vec4 finalcolor = pow(temp3, vec4(0.5) ); 
	finalcolor.w = 1.0;

	gl_FragColor = finalcolor;
}