function aam=read_in_pointmodels(aam,cwd)
% function aam=read_in_pointmodels(aam,cwd)

ind=findstr(aam.modelDirec(19:end),filesep)+17;
dirname=[pwd, filesep, 'PointModels', filesep, aam.modelDirec(19:ind(1))];
d=dir([dirname, filesep,'*_pm*']);
%now go through the list of files that we need, taking them from the dir
dnames={d.name};
pmt=get(aam, 'PointModelTemplate');
completed=[];
els = {};
fprintf('Using point models\n');
wh = waitbar(0, 'Loading point models...');
for i=1:length(aam.am_imagenames)
    waitbar(i/length(aam.am_imagenames), wh);
    imagename=aam.am_imagenames{i};
    [pathname, filename, ext, vers] = fileparts(imagename);
    %[n] = findimagenamefromdisk(dnames, filename);
    %if ~isempty(n)
    %    if length(n)>1
    %        fprintf('Warning: found more than one possible point model file.\nUsing the first one\n');
    %        n = n(1);
    %    end
    %  fprintf('%s\n', [dirname, filesep, dnames{n}]);
    filename = [dirname, filesep, filename, '_pm.mat'];
    if exist(filename)
        temp=load(filename);
        [r,c]=size(temp.pts');
        pts=reshape(temp.pts,2,round(c/2));
        els{end+1}=AAM_Element;% aam.elements{i};
        loops=get(pmt,'loops');
        if length(loops)>0
            els{end}=set(els{end},'loops',loops{1});
        end
        els{end}=set(els{end},'closedloops',get(pmt,'closedloops'));
        els{end}=set(els{end},'imagefilename',imagename);
        els{end}=set(els{end},'alignedPts',pts);
        els{end}=set(els{end},'pts',pts);
        completed=[completed,i];
    else
        str = sprintf('WARNING: non-existent pointmodel %s - ignoring',filename);
        fprintf('%s\n', str);
        %uiwait(warndlg(str));
    end
end
close(wh);
aam=set(aam,'elements',els);
aam=set(aam,'completeElements',completed);
%%%%%
%
%
%%%%%
function [n, dnames] = findimagenamefromdisk(dnames, filename)
n = [];
for i=1:length(dnames)
    name = dnames{i};
    [pathname, name, ext, vers] = fileparts(name);
    name = name(1:end-3);
    if strmatch(lower(name), lower(filename), 'exact')
        n = i;
        dnames(i) = [];
        return;
    end
end
return;
