%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
% aam = UpdateAAMFromDisk(aam);
%
% This function updates the AAM data structure that is passed between GUI's
% and reloads the relavent information that is written to disk.
%
% Dr. A. I. Hanna 2005
function [aam] = UpdateAAMFromDisk(aam)
wh = waitbar(0, 'Updating data from disk...');
% First make sure we have the correct template from disk
%PMT = get(aam, 'PointModelTemplate');
pmt = get(aam, 'PointModelTemplate');
if isa(pmt,'PointModelTemplate')
    PMT=pmt;
else
    PMT=PointModelTemplate(pmt);
end
PMT = set(PMT, 'direc', 'Templates');
if ~(exist([get(PMT, 'direc'), filesep, get(PMT, 'name')])==2)
    uiwait(warndlg(sprintf('Could not load Template file\n %s\n', [get(PMT, 'direc'), filesep, get(PMT, 'name')])));
    aam = AAM;
    return;
end
waitbar(.3, wh);
updatePMT = load([get(PMT, 'direc'), filesep, get(PMT, 'name')], '-mat');
updatePMT = updatePMT.PMTemplate;
template_pts = get(updatePMT, 'pts');

aam = set(aam, 'PointModelTemplate', updatePMT);

filesJPG = dir(['Cropped', filesep, '*.JPG']);
filesJPG = {filesJPG.name};
filesjpg = dir(['Cropped', filesep, '*.jpg']);
filesjpg = {filesjpg.name};
filenames = union(filesJPG, filesjpg);


aam = set(aam, 'imageFilenames', filenames);
waitbar(.6, wh);


% Now we must update the elements structure, i.e. the point models.
% [templatepath, templatename, ext, vers] = fileparts(get(updatePMT, 'name'));
% elements = get(aam, 'elements');
% pm_dir = ['PointModels', filesep, templatename];
% if exist(pm_dir, 'dir')
%     files = dir([pm_dir, filesep, '*_pm.mat']);
%     files = {files.name};
%     e_indx = 1;
%     wh = waitbar(0, 'Updating data from disk...');
%     for f = 1:length(files)
%         waitbar(f/length(files), wh);
%        pts = load( [pm_dir, filesep,files{f}]);
%        pts = pts.pts;
%        if size(pts,1)~=2
%            pts = reshape(pts, 2, length(pts)/2);
%        end
%        template_pt_number=size(template_pts,2);
%        pointmodel_pt_number=size(pts,2);
%        if template_pt_number ~= pointmodel_pt_number
%            fprintf(sprintf('Template %s\n has %d points and\n%s point model has %d points', [get(PMT, 'name')], template_pt_number, files{f},pointmodel_pt_number));
%            %uiwait(warndlg());
%            return;
%        end
%        imagefilename = files{f};
%        imagefilename = [imagefilename(1:end-7), '.jpg'];
%        temp = AAM_Element;
%        temp = set(temp, 'pts', pts);
%        temp = set(temp, 'imagefilename', imagefilename);
%        temp = set(temp, 'primaries', get(updatePMT, 'primaries'));
%        temp = set(temp, 'loops', get(updatePMT, 'loops'));
%        if exist(['Cropped', filesep, imagefilename])
%         elements{e_indx} = temp;
%         e_indx = e_indx + 1;
%        end
%     end
%     close(wh);
% end
%aam = set(aam, 'elements', elements);
modelfilename=[pwd, filesep, get(aam, 'modelDirec'), filesep, get(aam, 'modelName')];
fprintf('Saving AAM...'); 
save(modelfilename, 'aam');
waitbar(1, wh);
fprintf('done.\n');
close(wh);
return;
